local Enabled = false

-- ADS Helper
function IsPlayerAiming()

    blackboardDefs = Game.GetAllBlackboardDefs().PlayerStateMachine
    blackboard = Game.GetBlackboardSystem():GetLocalInstanced(Game.GetPlayer():GetEntityID(), blackboardDefs)
    
    return blackboard:GetInt(Game.GetAllBlackboardDefs().PlayerStateMachine.UpperBody) == 4
    
end

-- Fire
registerForEvent("onUpdate", function()
    
    -- Systems
    local Player            = Game.GetPlayer()
    local TransactionSystem = Game.GetTransactionSystem()
    local PlayerSystem      = Game.GetPlayerSystem()
    local PlayerPuppet      = PlayerSystem:GetLocalPlayerMainGameObject()
    
    -- Player not found
    if PlayerPuppet == nil then
        return
    end
    
    -- Vars
    local Camera = PlayerPuppet:GetFPPCameraComponent()
    local Weapon = TransactionSystem:GetItemInSlot(PlayerPuppet, TweakDBID.new("AttachmentSlots.WeaponRight"))
    
    -- Bail early
    if Enabled == nil or Enabled == false or Weapon == nil then
    
        Camera:SetLocalPosition(Vector4:new(0.0, 0.0, 0.0, 1.0))
        return
        
    end
    
    -- Weapon data
    local WeaponData = TransactionSystem:GetItemData(PlayerPuppet, Weapon:GetItemID())
    local WeaponType = WeaponData:GetItemType().value
    
    -- ADS
    if IsPlayerAiming() then
    
        delay = 9
        Camera:SetLocalPosition(Vector4:new(0.0, 0.0, 0.0, 1.0))
        
    else
        
        if delay ~= nil and delay > 0 then
            
            delay = delay-1
        
        else
            
            -- Shotgun
            if WeaponType == 'Wea_Shotgun' then
            
                Camera:SetLocalPosition(Vector4:new(0.02, 0.08, -0.06, 1.0))
                
            -- Doublebarrel
            elseif  WeaponType == 'Wea_ShotgunDual' then   

                Camera:SetLocalPosition(Vector4:new(0.03, 0.18, -0.07, 1.0))
            
            -- SMG && Rifle
            elseif WeaponType == 'Wea_SubmachineGun' or WeaponType == 'Wea_Rifle' then
            
                Camera:SetLocalPosition(Vector4:new(0.01, 0.02, -0.04, 1.0))
                
            -- LMG
            elseif WeaponType == 'Wea_LightMachineGun' then
            
                Camera:SetLocalPosition(Vector4:new(0.01, 0.02, -0.04, 1.0))   
                
            -- Sniper
            elseif WeaponType == 'Wea_SniperRifle' then
            
                Camera:SetLocalPosition(Vector4:new(0.01, 0.02, -0.02, 1.0))
                
            else
            
                Camera:SetLocalPosition(Vector4:new(0.0, 0.0, 0.0, 1.0))
                
            end
        
        end
        
    end
    
end)

function init(Enabled)
    
    if Enabled == true then
        Game.GetPlayer():SetWarningMessage('Weapon FOV: Enabled');
    else
        Game.GetPlayer():SetWarningMessage('Weapon FOV: Disabled');
    end

end

-- Hotkey: Enable
registerHotkey('weapon_fov_enable', 'Weapon FOV: Enable', function()

    -- Switch
    Enabled = true
    init(true)
    

end)

-- Hotkey: Disable
registerHotkey('weapon_fov_disable', 'Weapon FOV: Disable', function()

    -- Switch
    Enabled = false
    init(false)

end)